<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;

class Login extends BaseController
{
    protected $userModel;
    protected $session;

    public function __construct()
    {
        helper(['form', 'url']);

        $this->userModel = new UserModel();
        $this->session   = session();
    }

    public function index()
    {
        return view('login/index');
    }

    public function loginAuth()
    {
        $request  = service('request');
        $username = trim($request->getPost('username'));
        $password = $request->getPost('password');

        if ($username === '' || $password === '') {
            return redirect()->to('login')
                ->with('status', 'Username and password required');
        }

        $user = $this->userModel->getActiveUserByUsername($username);

        if (!$user) {
            return redirect()->to('login')
                ->with('status', 'Invalid username or inactive account');
        }

        // Allow plain-text password (current system)
        // AND future hashed passwords
        if (
            $password !== $user['password'] &&
            !password_verify($password, $user['password'])
        ) {
            return redirect()->to('login')
                ->with('status', 'Invalid password');
        }


        // SESSION (FOUNDATION)
        $this->session->set([
            'user_id'    => $user['id'],
            'username'   => $user['username'],
            'name'       => $user['name'],
            'email'      => $user['email_id'],
        
            // existing (keep)
            'role'       => $user['role'],
        
            // NEW (for permission system)
            'role_id'    => $user['role_id'],
        
            'isLoggedIn' => true,
        ]);

        return redirect()->to('dashboard');
    }

    public function logout()
    {
        $this->session->destroy();
        return redirect()->to('login');
    }
}
