<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table      = 'admin_login';
    protected $primaryKey = 'id';
    protected $returnType = 'array';

    protected $allowedFields = [
        'name',
        'username',
        'password',
        'role',
        'role_id',
        'email_id',
        'mobile',
        'address',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';

    public function getActiveUserByUsername(string $username): ?array
    {
        return $this->where('username', $username)
                    ->where('status', 1)
                    ->first();
    }

}
