<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<link rel="canonical" href="https://demo-basic.adminkit.io/pages-sign-in.html" />

	<title>Sign In | A&A Medical</title>

	<!-- Theme Style CSS -->
	<?= link_tag('public/css/app.css') ?>
	<?= link_tag('public/css/light.css') ?>
	<?= link_tag('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap') ?>	

	<?php
	$favicon = [
		'href'  => 'public/img/icons/icon-48x48.png',
		'rel'   => 'shortcut icon',
		'type'  => 'image/png',
	];
	echo link_tag($favicon);
	?>
</head>

<style>
    @keyframes shake {
        0% { transform: translateX(0); }
        20% { transform: translateX(-5px); }
        40% { transform: translateX(5px); }
        60% { transform: translateX(-5px); }
        80% { transform: translateX(5px); }
        100% { transform: translateX(0); }
    }
    .shake {
        animation: shake 0.4s ease-in-out;
    }
</style>


<body style="background: url('<?= base_url('public/img/login-bg.jpg') ?>') no-repeat center center fixed; background-size: cover;">
    
  <div style="background: rgba(0,0,0,0.45); min-height: 100vh;">
	<main class="d-flex w-100">
		<div class="container d-flex flex-column">
			<div class="row vh-100">
				<div class="col-sm-10 col-md-8 col-lg-6 col-xl-5 mx-auto d-table h-100">
					<div class="d-table-cell align-middle">

						<div class="card shadow-lg border-0 rounded-4" style="backdrop-filter: blur(6px);">
							<div class="card-body" style="background: rgba(255,255,255,0.95); border-radius: 1rem;">
								<div class="text-center mt-4">
									<img src="<?= base_url('public/img/logo.png') ?>" 
                                         alt="A&A Medical"
                                         style="max-height:80px; margin-bottom:5px;">
									<p class="lead">
										Sign in to your account to continue
									</p>
								</div>

								<?php if (session()->getFlashdata('status')): ?>
                                    <div class="alert alert-warning shake">
                                        <?= session()->getFlashdata('status') ?>
                                    </div>
                                <?php endif; ?>

								<div class="m-sm-3">
									<form action="<?= base_url('loginAuth') ?>" method="POST" novalidate>

                                        <?= csrf_field() ?>
                                    
                                        <div class="mb-3">
                                            <label class="form-label">User Name</label>
                                            <input
                                                class="form-control form-control-lg"
                                                type="text"
                                                name="username"
                                                placeholder="Username"
                                                required
                                                autocomplete="username"
                                            />
                                        </div>
                                    
                                        <div class="mb-3">
                                            <label class="form-label">Password</label>
                                            <input
                                                class="form-control form-control-lg"
                                                type="password"
                                                name="password"
                                                placeholder="Password"
                                                required
                                                autocomplete="current-password"
                                            />
                                        </div>
                                    
                                        <div class="d-grid gap-2 mt-3">
                                            <button type="submit" id="loginBtn" class="btn btn-lg btn-primary">
                                                <span id="btnText">Sign In</span>
                                                <span id="btnSpinner" class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        </div>
                                    
                                    </form>

								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</main>
	
	<script>
        const form = document.querySelector('form');
        const btn = document.getElementById('loginBtn');
        const btnText = document.getElementById('btnText');
        const spinner = document.getElementById('btnSpinner');
    
        form.addEventListener('submit', function () {
            btn.disabled = true;
            btnText.textContent = 'Signing In...';
            spinner.classList.remove('d-none');
        });
    </script>


	<!-- Script -->
	<?= script_tag('public/js/app.js') ?>
  </div>
</body>

</html>
